# **Appalachian Aliens Write-Up**

# **Challenge Overview**

This challenge involves investigating a mysterious audio file that was delivered to the Danville Police Department by someone named "Dave". The file appears to contain hidden messages related to an alien invasion warning, requiring various forensic and decoding techniques to solve.

## **Initial Scenario**

According to the briefing:

* A USB stick containing an audio file was dropped off at Danville PD  
* The USB transmitted a signal for 10 minutes before self-destructing  
* FBI agents experienced severe symptoms when analyzing the file  
* The Tiberian Order and Kumgon engineers isolated the audio for analysis

## **Solution Steps**

### **Step 1: Audio Spectrogram Analysis**

The first step involves analyzing the spectrogram of the provided audio file. This reveals two crucial pieces of information:

1. A warning message: "they are coming be warned humans"  
2. A hexadecimal string: 67 61 6c 61 63 74 69 63 66 69 6c 65 73 2e 6f 72 67

### **Step 2: Hex Decoding**

The hexadecimal string needs to be decoded:

* Hex: 67 61 6c 61 63 74 69 63 66 69 6c 65 73 2e 6f 72 67  
* Decoded text: galacticfiles.org This provides a URL for the next step of the challenge.

### **Step 3: Website Investigation**

The website galacticfiles.org contains:

* Alien lore and background information  
* Alien text images that need to be deciphered  
* A hidden message from the "Pleiadean Council of Light"

### **Step 4: Message Analysis**

The key message contains encoded coordinates: "The landings will commence at three seven point four five five three two seven comma space minus seven nine point nine eight one two four one"

This translates to the coordinates: 37.455327, \-79.981241

### **Step 5: Location Identification**

The coordinates point to:

* Roanoke Cement Co  
* Address: 6071 Catawba Rd, Troutville, VA 24175, United States

## **Final Answer Construction**

The answer format requires:

* Coordinate numbers (without decimal points)  
* The road name next to the facility

Format: \[first coordinate\]-\[second coordinate\]-\[road name\] Answer: 37455327-79981241-catawba-rd

## **Challenge Elements**

The CTF combines several skills:

* Audio forensics (spectrogram analysis)  
* Hex decoding  
* Web investigation  
* Coordinate decoding  
* Attention to detail in formatting the final answer

## **Additional Context**

The challenge incorporates an interesting narrative about alien invasion warnings and government conspiracy, adding an engaging layer to the technical aspects of the solution. The story involves multiple alien races (Pleiadeans warning about Krohndahkyr) and references to hybrid agents infiltrating governments.

## **Verification Steps**

To verify the solution:

1. Confirm coordinate numbers are stripped of all punctuation  
2. Verify road name is in lowercase with correct spelling  
3. Ensure all parts are connected with hyphens  
4. Double-check against the answer format provided in the instructions

